﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.OleDb;
using System.Data;

namespace Persistance
{
    /// <summary>
    /// Classe permettant d'accèder et d'interagir avec une BD ORACLE
    /// </summary>
    class InterfaceBD
    {
        /// <summary>
        /// Exécute une requête de lecture dans la base (SQL SELECT)
        /// </summary>
        /// <param name="requete">la requête SQL SELECT</param>
        /// <returns>les données renvoyées par la requête</returns>
        public DataTable ExecuterRequeteLecture(string requete)
        {
            OleDbConnection connexion = Connecter();

            OleDbCommand cmd = new OleDbCommand();
            cmd.Connection = connexion;
            cmd.CommandText = requete;

            OleDbDataAdapter da = new OleDbDataAdapter();
            da.SelectCommand = cmd;
            DataSet ds = new DataSet();
            da.Fill(ds, "resultat");
            connexion.Close();

            DataTable dt = ds.Tables["resultat"];
            return dt;
        }

        /// <summary>
        /// Exécute une requête de modification des données (SQL INSERT ou UPDATE)
        /// </summary>
        /// <param name="requete">la requête SQL</param>
        public void ExecuterRequeteModification(string requete)
        {
            OleDbConnection connexion = Connecter();

            OleDbCommand cmd = new OleDbCommand();
            cmd.Connection = connexion;
            cmd.CommandText = requete;

            cmd.ExecuteNonQuery();
            connexion.Close();
        }

        /// <summary>
        /// Permet de se connecter à la BD
        /// </summary>
        /// <returns>un objet de connexion</returns>
        private OleDbConnection Connecter()
        {
            OleDbConnection connexion = new OleDbConnection();
            connexion.ConnectionString =
                "Provider=MSDAORA.1; User ID=tfloq;Password=tfloq;Data Source=tns_srv1";
            
            connexion.Open();

            return connexion;
        }
    }
}
